/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModeloValoresAir
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String[]>> tiposDeConceptos;
    private UtilCatalogosATS catalogos;
    private TransaccionCompra compraSeleccionada;
    private final Periodo periodo;
    private final String esMicroEmpresa;
    private final Date fechaSeleccContable;

    public ModeloValoresAir(Periodo periodo, String esMicroEmpresa, Date fechaSeleccContable, TransaccionCompra compraSeleccionada) {
        this.periodo = periodo;
        this.esMicroEmpresa = esMicroEmpresa;
        this.tiposDeConceptos = new TreeMap<String, ElementoNombreValor<String[]>>();
        this.catalogos = UtilCatalogosATS.crearInstancia();
        this.fechaSeleccContable = fechaSeleccContable;
        this.compraSeleccionada = compraSeleccionada;
    }

    public Map<String, BigDecimal> obtenerTarifaEfectivaRetencionBanano(String codigoRetencion, double numeroCajas, BigDecimal precioCajaBanano, double porcentajeRecepcion) {
        BigDecimal numeroCajasCalculo = new BigDecimal(numeroCajas);
        BigDecimal valorFacturado = numeroCajasCalculo.multiply(precioCajaBanano);
        String regexUnicoExportacionBananoProducidoTerceros = "^(342).*$";
        if (codigoRetencion.matches(regexUnicoExportacionBananoProducidoTerceros) || "341".equals(codigoRetencion)) {
            return this.calcularImpuestoBananoExportador(numeroCajasCalculo, precioCajaBanano, valorFacturado);
        }
        return this.calcularImpuestoBananoProductor(precioCajaBanano, numeroCajasCalculo, valorFacturado, porcentajeRecepcion);
    }

    private Map<String, BigDecimal> calcularImpuestoBananoProductor(BigDecimal precioCajaBanano, BigDecimal numeroCajasCalculo, BigDecimal valorFacturado, double porcentajeRetencion) {
        Hashtable<String, BigDecimal> valoresCalculados = new Hashtable<String, BigDecimal>();
        valorFacturado = valorFacturado.setScale(6, 3);
        BigDecimal limite = BigDecimal.ZERO;
        BigDecimal residuo = BigDecimal.ZERO;
        BigDecimal porcentajeRetencionFila1 = new BigDecimal("0.01");
        BigDecimal porcentajeRetencionFila2 = new BigDecimal("0.0125");
        BigDecimal porcentajeRetencionFila3 = new BigDecimal("0.0150");
        BigDecimal porcentajeRetencionFila4 = new BigDecimal("0.02");
        if (this.periodo.isPeriodoHastaDiciembre2019()) {
            limite = numeroCajasCalculo.subtract(new BigDecimal(500));
            if (limite.longValue() <= 0L) {
                valoresCalculados.put("porcentajeRetenido", porcentajeRetencionFila1.multiply(new BigDecimal(100.0)));
                valoresCalculados.put("valorRetenido", porcentajeRetencionFila1.multiply(valorFacturado));
            } else {
                numeroCajasCalculo = limite.subtract(new BigDecimal(500));
                if (numeroCajasCalculo.longValue() <= 0L) {
                    residuo = limite;
                    BigDecimal valorFila1 = new BigDecimal(500).multiply(porcentajeRetencionFila1).multiply(precioCajaBanano);
                    BigDecimal valorFila2 = residuo.multiply(porcentajeRetencionFila2).multiply(precioCajaBanano);
                    BigDecimal acumuladoValorRetenido = valorFila1.add(valorFila2);
                    valoresCalculados.put("porcentajeRetenido", acumuladoValorRetenido.divide(valorFacturado, 6, 1).multiply(new BigDecimal(100.0)));
                    valoresCalculados.put("valorRetenido", acumuladoValorRetenido);
                } else {
                    limite = numeroCajasCalculo.subtract(new BigDecimal(2000));
                    if (limite.longValue() <= 0L) {
                        residuo = numeroCajasCalculo;
                        BigDecimal valorFila1 = new BigDecimal(500).multiply(porcentajeRetencionFila1).multiply(precioCajaBanano);
                        BigDecimal valorFila2 = new BigDecimal(500).multiply(porcentajeRetencionFila2).multiply(precioCajaBanano);
                        BigDecimal valorFila3 = residuo.multiply(porcentajeRetencionFila3).multiply(precioCajaBanano);
                        BigDecimal acumuladoValorRetenido = valorFila1.add(valorFila2).add(valorFila3);
                        valoresCalculados.put("porcentajeRetenido", acumuladoValorRetenido.divide(valorFacturado, 6, 1).multiply(new BigDecimal(100.0)));
                        valoresCalculados.put("valorRetenido", acumuladoValorRetenido);
                    } else {
                        residuo = limite;
                        BigDecimal valorFila1 = new BigDecimal(500.0).multiply(porcentajeRetencionFila1).multiply(precioCajaBanano);
                        BigDecimal valorFila2 = new BigDecimal(500.0).multiply(porcentajeRetencionFila2).multiply(precioCajaBanano);
                        BigDecimal valorFila3 = new BigDecimal(2000.0).multiply(porcentajeRetencionFila3).multiply(precioCajaBanano);
                        BigDecimal valorFila4 = residuo.multiply(porcentajeRetencionFila4).multiply(precioCajaBanano);
                        BigDecimal acumuladoValorRetenido = valorFila1.add(valorFila2).add(valorFila3).add(valorFila4);
                        valoresCalculados.put("porcentajeRetenido", acumuladoValorRetenido.divide(valorFacturado, 6, 1).multiply(new BigDecimal(100.0)));
                        valoresCalculados.put("valorRetenido", acumuladoValorRetenido);
                    }
                }
            }
        } else {
            valoresCalculados.put("porcentajeRetenido", BigDecimal.valueOf(porcentajeRetencion));
            valoresCalculados.put("valorRetenido", BigDecimal.valueOf(porcentajeRetencion).multiply(valorFacturado));
        }
        return valoresCalculados;
    }

    public Map<String, BigDecimal> calcularImpuestoBananoExportador(BigDecimal numeroCajas, BigDecimal precioCajaBanano, BigDecimal valorFacturado) {
        Hashtable<String, BigDecimal> valoresCalculados = new Hashtable<String, BigDecimal>();
        BigDecimal porcentajeRetencionFila1 = new BigDecimal("0.0125");
        BigDecimal porcentajeRetencionFila2 = new BigDecimal("0.0150");
        BigDecimal limite = BigDecimal.ZERO;
        BigDecimal residuo = BigDecimal.ZERO;
        BigDecimal numeroCajasCalculo = numeroCajas;
        valorFacturado = valorFacturado.setScale(6, 3);
        limite = numeroCajasCalculo.subtract(new BigDecimal(50000.0));
        if (limite.longValue() <= 0L) {
            valoresCalculados.put("porcentajeRetenido", porcentajeRetencionFila1.multiply(new BigDecimal(100.0)));
            valoresCalculados.put("valorRetenido", porcentajeRetencionFila1.multiply(valorFacturado));
        } else {
            residuo = limite;
            BigDecimal valorFila1 = new BigDecimal(50000.0).multiply(porcentajeRetencionFila1).multiply(precioCajaBanano);
            BigDecimal valorFila2 = residuo.multiply(porcentajeRetencionFila2).multiply(precioCajaBanano);
            BigDecimal acumuladoValorRetenido = valorFila1.add(valorFila2);
            valoresCalculados.put("porcentajeRetenido", acumuladoValorRetenido.divide(valorFacturado, 6, 1).multiply(new BigDecimal(100.0)));
            valoresCalculados.put("valorRetenido", acumuladoValorRetenido);
        }
        return valoresCalculados;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposDeConceptos();
            this.inicializado = true;
        }
    }

    private void cargarTiposDeConceptos() {
        this.tiposDeConceptos.clear();
        Map datos = this.catalogos.obtenerRentenciones(this.periodo.getMes(), this.periodo.getAnio(), this.esMicroEmpresa, this.fechaSeleccContable);
        for (Map.Entry retencion : datos.entrySet()) {
            if (!"01".equals(this.compraSeleccionada.getPagoLocalExterior().getFiscalidad().getTipoPago())) {
                if (!((String)retencion.getKey()).substring(0, 1).equals("5")) continue;
                this.tiposDeConceptos.put((String)retencion.getKey(), (ElementoNombreValor<String[]>)new ElementoNombreValor(String.valueOf((String)retencion.getKey()) + "-" + ((String[])retencion.getValue())[0], (Object)new String[]{(String)retencion.getKey(), ((String[])retencion.getValue())[1]}));
                continue;
            }
            if (!((String)retencion.getKey()).substring(0, 1).equals("3")) continue;
            this.tiposDeConceptos.put((String)retencion.getKey(), (ElementoNombreValor<String[]>)new ElementoNombreValor(String.valueOf((String)retencion.getKey()) + "-" + ((String[])retencion.getValue())[0], (Object)new String[]{(String)retencion.getKey(), ((String[])retencion.getValue())[1]}));
        }
        this.eliminarCodigo348EnAnexosAnterioresAJunio2016();
        this.eliminarCodigos347Y525EnAnexosAnterioresAJulio2016();
        this.eliminarCodigo349EnAnexosAnterioresAOctubre2016();
    }

    private void eliminarCodigo349EnAnexosAnterioresAOctubre2016() {
        if (this.periodo.isAnexoEnPeriodoHastaSeptiembre2016() && this.tiposDeConceptos.containsKey("349")) {
            this.tiposDeConceptos.remove("349");
        }
    }

    private void eliminarCodigo348EnAnexosAnterioresAJunio2016() {
        if (this.periodo.isAnexoEnPeriodoHastaMayo2016() && this.tiposDeConceptos.containsKey("348")) {
            this.tiposDeConceptos.remove("348");
        }
    }

    private void eliminarCodigos347Y525EnAnexosAnterioresAJulio2016() {
        if (this.periodo.isAnexoEnPeriodoHastaJunio2016()) {
            if (this.tiposDeConceptos.containsKey("347")) {
                this.tiposDeConceptos.remove("347");
            }
            if (this.tiposDeConceptos.containsKey("525")) {
                this.tiposDeConceptos.remove("525");
            }
        }
    }

    public Map<String, BigDecimal> obtenerRetencionDividendos(BigDecimal baseImponible, Date fechaRegistroComprobante) {
        return this.catalogos.obtenerRetencionDividendosPorBaseImponible(baseImponible, fechaRegistroComprobante);
    }

    public List<ElementoNombreValor<String[]>> getTiposDeConceptos() {
        return new ArrayList<ElementoNombreValor<String[]>>(this.tiposDeConceptos.values());
    }

    public ElementoNombreValor<String[]> obtenerTipoConcepto(String codigoConcepto) {
        return StringUtil.isNullOrEmpty((String)codigoConcepto) ? null : this.tiposDeConceptos.get(codigoConcepto);
    }
}

